
struct OutputBuffer
{
	float3 Pos ;
	float3 norm ;
	float2 TexCd ;
	
};

ByteAddressBuffer ByteBuffer;
//RWStructuredBuffer<OutputBuffer> Output : BACKBUFFER;
RWStructuredBuffer<OutputBuffer> Output : BACKBUFFER;

[numthreads(64, 1, 1)]
void ByteAddressBuffer_CS( uint3 i : SV_DispatchThreadID)
{ 
uint index=i.x;
float Posx = asfloat(ByteBuffer.Load(index * 32));
float Posy = asfloat(ByteBuffer.Load(index * 32 + 4));	
float Posz = asfloat(ByteBuffer.Load(index * 32 + 8));
float Normx = asfloat(ByteBuffer.Load(index * 32 + 12));
float Normy = asfloat(ByteBuffer.Load(index * 32 + 16));
float Normz = asfloat(ByteBuffer.Load(index * 32 + 20));
float Texcoordsx = asfloat(ByteBuffer.Load(index * 32 + 24));
float Texcoordsy = asfloat(ByteBuffer.Load(index * 32 + 28));

Output[i.x].Pos=float3(Posx,Posy,Posz);
Output[i.x].norm=float3(Normx,Normy,Normz);
Output[i.x].TexCd=float2(Texcoordsx,Texcoordsy);
	
}

technique11 ByteAddressBufferT
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, ByteAddressBuffer_CS() ) );
	}
}





